#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
// #include <unistd.h>
// #include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
// #include <dirent.h>
#include <time.h>
#include <SDL/SDL.h>

#define MAX_THUMB_LINES        512
#define FILE_BUFFER_GROW_SIZE 8192

#define GROW_IMAGES_PER_LINE     2
#define SMOOTH_REBUILD_UNITS     8

#define MESSAGE_OUTPUT_QUIET     0
#define MESSAGE_OUTPUT_NORMAL    1
#define MESSAGE_OUTPUT_VERBOSE   2
#define MESSAGE_OUTPUT_DEBUG     3

SDL_Surface* ResizeImage(SDL_Surface*, long, short);

class Image
{
protected:
    char*        _p_filename;
    char*        _p_path;

    long         _location_x;

    SDL_Surface* _p_image;
    SDL_Surface* _p_thumb;

public:
    Image(char*, char*, long, SDL_Surface*, SDL_Surface*);
    virtual ~Image();

    long         GetXStart() {return _location_x;};
    long         GetXEnd() {return _location_x + _p_thumb->w;};
    void         SetXStart(long x) {_location_x = x;};
    SDL_Surface* GetImage();
    SDL_Surface* GetThumb() {return _p_thumb;};
    void         UnloadImage() {SDL_FreeSurface(_p_image); _p_image = NULL;};
    void         DisplayImage(SDL_Surface*, SDL_Rect*);
    void         WriteToCache(FILE*, FILE*);
}; // class Image

class ThumbLine
{
protected:
    Image** _p_image_array;
    short   _max_images;
    short   _index_next_image;

public:
    ThumbLine();
    ~ThumbLine();

    void   AddImage(Image*);
    void   BlockShift(long);
    void   Display(SDL_Surface*, long, long);
    void   Save(FILE*, FILE*);
    Image* GetImage(long);
}; // class ThumbLine
