// Particle.h: interface for the Particle class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PARTICLE_H__9A5AD001_662A_11D5_AA9C_00105A3759EB__INCLUDED_)
#define AFX_PARTICLE_H__9A5AD001_662A_11D5_AA9C_00105A3759EB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class Particle  
{
protected:
	static long _no_particles;
	
	short    _max_old_positions;
	short    *_p_old_pos_x, *_p_old_pos_y;
	short    _old_pos_index, _no_old_positions, _current_oldest_pos;
	long     _life_time;
	bool     _active, _vanished;
	
public:
	long  pos_x, pos_y;
	long  direction_x, direction_y;
	long  gravity_x, gravity_y;
	short _generation;
	
public:
	Particle();
	virtual ~Particle();
	
	void Init(long);
	void PushPosition();
	bool Vanished();
	bool GetOldestPosition(short&, short&);
	bool GetSecondYoungestPosition(short&, short&, long&);
	
	void SetActive(bool);
	bool IsActive() {return _active;};
	void SetVanished() {_vanished = true;};
	
	
	static void ResetNoParticles() {_no_particles = 0;};
	static long GetNoParticles() {return _no_particles;};
};

inline void Particle::PushPosition()
{
	_life_time++;
	
	if(!Vanished()) {
		
		if(_no_old_positions < _max_old_positions) {
			
			if(_old_pos_index == _max_old_positions) _old_pos_index = 0;
			
			_p_old_pos_x[_old_pos_index] = pos_x >> 16;
			_p_old_pos_y[_old_pos_index] = pos_y >> 16;

			_old_pos_index++;
			
			_no_old_positions++;
		} // if
	} // if
	else {
		if(_no_old_positions < 1) {
			SetActive(false);
			Init(_max_old_positions);
		} // if
	} // else
} // Particle::PushPosition

inline bool Particle::GetOldestPosition(short& pos_x, short& pos_y)
{
	if((!Vanished()) && (_no_old_positions < _max_old_positions)) return false;

	if(_no_old_positions < 1) {
		SetActive(false);
		Init(_max_old_positions);
		return false;
	} // if

	if(_current_oldest_pos == _max_old_positions) _current_oldest_pos = 0;

	pos_x = _p_old_pos_x[_current_oldest_pos];
	pos_y = _p_old_pos_y[_current_oldest_pos];

	_current_oldest_pos++;
	_no_old_positions--;

	return true;
} // Particle::GetOldestPosition

inline bool Particle::GetSecondYoungestPosition(short& pos_x, short& pos_y, long& lifetime)
{
	short temp_pos;

	lifetime = _life_time;

	if((!Vanished()) && (_no_old_positions < (_max_old_positions-1))) return false;

	temp_pos = _old_pos_index - 1;

	if(temp_pos < 0) temp_pos = _max_old_positions - 1;

	pos_x = _p_old_pos_x[temp_pos];
	pos_y = _p_old_pos_y[temp_pos];

	return true;
} // Particle::GetSecondYoungestPosition

inline bool Particle::Vanished()
{
	return _vanished;
} // Particle::Vanished

inline void Particle::SetActive(bool active)
{
	_active = active;

	if(_active) _no_particles++;
	else _no_particles--;
} // Particle::SetActive


#endif // !defined(AFX_PARTICLE_H__9A5AD001_662A_11D5_AA9C_00105A3759EB__INCLUDED_)
