// SDLTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "xparticles.h"
#include "particle.h"
#include "getopt.h"
#include <sys/timeb.h>
#include <math.h>

int  global_message_output;
long simul_time = 0;
long _no_particles;
long _last_index;
long index_particle = 0;
bool _left_button_pressed = false;
bool _auto_move = false;
Particle* _p_particle = NULL;
long _no_glow_particles = 22;
long _none_moving_count = 0;
long _no_explosions = 0;
long _emission_speed = 910;
long _emission_size = 15;
long _speed_auto_move = 5;
long _gravity = 4;
double	_gravity_constant = 0.004;
long _mid_point;
long _delta_x;
long* _p_ground;

#define MSG_HELP_TEXT 1

void MessageText(int id_text, bool debug)
{
    char* p_message;

    switch(id_text) {

	case MSG_HELP_TEXT:
	    p_message = "winparticles v1.0 - a particle simulation copyright 2002 by Thomas Haenselmann\n"\
		"please visit www.haenselmann.de/homebrew for further information\n\n"\
		"options\n"\
		"-a,          automatic animation\n"\
		"-f,          fullscreen\n"\
		"-h,          this text\n"\
		"-p n         n = max number of particles (default = 20000)\n"\
		"-c FILENAME  capture your moves in a text file FILENAME\n"\
		"-y FILENAME  play moves captured with -c\n"\
		"-r n         n = 0:640x480 1:800x600 2:1024x768 (default)\n"\
		"                 3:1280x1024 4:1600x1200\n"\
		"-d           use on dual processor mashines only\n\n"\
		"exit program: q, Q or ESC key\n";

	    break;

	default:
	    p_message = "message not defined - error in MessageText(...)\n";
	    break;
    } // switch

    if(debug) cerr << endl << p_message;
    else cout << endl << p_message;
} // MessageText

long EmmitNewParticle(int x, int y)
{
    long current_particle_index;
    float speed, dir;
    const float base_speed = 3.0;

    if(_p_particle[index_particle].IsActive())
	    return -1;
	
    _p_particle[index_particle].Init(_no_glow_particles);
	
    _p_particle[index_particle].pos_y = (y + (rand() % _emission_size)) << 16;
    _p_particle[index_particle].pos_x = (x + (rand() % _emission_size)) << 16;
    
    speed = (((float) (rand() % 1000) / 1000) - 0.5) * base_speed;
    dir = ((float) (rand() % 360)) / 0.017;
    _p_particle[index_particle].direction_x = (long) (speed * cos(dir) * (float) 0xFFFF);
    _p_particle[index_particle].direction_y = (long) (speed * sin(dir) * (float) 0xFFFF);
    
    _p_particle[index_particle].gravity_x = 0;
    _p_particle[index_particle].gravity_y = 0;
    
    _p_particle[index_particle].SetActive(true);
    
    current_particle_index = index_particle;
    
    index_particle++;
    
    if(index_particle >= _no_particles) {
	index_particle = 0;
    } // if
    
    if(index_particle > _last_index) _last_index = index_particle;
    
    return current_particle_index;
} // EmmitNewParticle

long GetCurMilSec(timeb* p_initial_time)
{
    timeb current_time;

    ftime(&current_time);

    return ((long)(current_time.time - p_initial_time->time)*1000l + ((long)current_time.millitm - (long)p_initial_time->millitm));
} // GetCurMilSec

int main(int argc, char** argv)
{
    SDL_Surface      *screen, *backup_screen;
    SDL_Event        event;
    SDL_Rect         dst_rect, full_image_rect, scrolled_rect, location;
    int              window_width, window_height, thumb_height, thumb_border_size;
    char             c;
    short            old_pos_x, old_pos_y;
    short	     second_oldest_pos_x, second_oldest_pos_y;
    long	     pos_x, pos_y;
    long             lifetime;
    bool             particle_valid, full_screen;       
    bool             dual_processor;       
    long             i, update_min_x, update_max_x;
    long             update_min_y, update_max_y, size_line;
    SDL_Color        colors[256];
    timeb            last_time, current_time, initial_time;
    timeb            first_delay_time, second_delay_time;
    int              option_index;
    SDL_MouseMotionEvent current_point, prev_point;
    char*            protocol_filename;
    ofstream*        p_proto_stream;
    ifstream*        p_play_stream;
    long             compare_time, last_compare_time, play_file_time;
    long             base_width, base_height;
    bool             play;
/* 
    static struct option long_options[] = {
	{"help", 0, 0, 0},
	{"auto", 0, 0, 0},
	{"fullscreen", 0, 0, 0},
	{"resolution", 1, 0, 0},
	{"max_particles", 1, 0, 0},
	{"dual", 0, 0, 0},
	{"capture", 1, 0, 0},
	{"play", 1, 0, 0},
	{0, 0, 0, 0}
    };
*/
	cout << "winparticles: exit program: q, Q or ESC key" << endl;
	cout << "winparticles -h for help" << endl;
    
	 update_min_x = update_max_x = update_min_y = update_max_y = 0;

    for(i = 0; i < 256; i++) {

	if(i > 170) {
	    colors[i].r = 255;
	    colors[i].g = 255;
	    colors[i].b = 0;
	} // if
	else {
	    colors[i].r = (unsigned char)((i*255/170)*4/8+(255*4/8-1));
	    colors[i].g = (unsigned char)((i*255/170)*6/6+(255*0/6-1));
	    colors[i].b = 0;
	} // else
    } // for

    colors[0].r = colors[0].g = colors[0].b = 0;
    colors[255].r = colors[255].g = colors[255].b = 255;

    full_screen = false;
    _no_particles = 40000;
    dual_processor = false;

    window_width = 1024; window_height = 768;

    global_message_output = MESSAGE_OUTPUT_NORMAL;
    protocol_filename = NULL;
    p_proto_stream = NULL;
    p_play_stream = NULL;
    play = false;

    // analyze command line

    while(true) {

/* static (global) variables that are specified as exported by getopt() */ 
// char *optarg = NULL;    /* pointer to the start of the option argument  */ 
// int   optind = 1;       /* number of the next argv[] to be evaluated    */ 
// int   opterr = 1;       /* non-zero if a question mark should be returned 
//                           when a non-valid option character is detected */ 
 
/* handle possible future character set concerns by putting this in a macro */ 
// #define _next_char(string)  (char)(*(string+1)) 
 
// int getopt(int argc, char *argv[], char *opstring) 


	c = getopt(argc, argv, "hr:p:fadc:y:");

	if(c < 0) break;

	switch(c) {

	    case 'a':
		_auto_move = true;
		break;

	    case 'h':
		MessageText(MSG_HELP_TEXT, false);
		exit(0);
		break;

	    case 'r':
		switch(atoi(optarg)) {
		    case 0:
			window_width = 640; 
			window_height = 480;
			break;

		    case 1:
			window_width = 800; 
			window_height = 600;
			break;

		    case 2:
			window_width = 1024; 
			window_height = 768;
			break;

		    case 3:
			window_width = 1280; 
			window_height = 1024;
			break;

	    case 4:
			window_width = 1600; 
			window_height = 1200;
			break;

		} // switch
		break;

	    case 'p':
		_no_particles = atoi(optarg);
		break;

	    case 'f':
		full_screen = true;
		break;

	    case 'd':
		dual_processor = true;
		break;

	    case 'c':
		protocol_filename = optarg;
		play = false;
		break;

	    case 'y':
		protocol_filename = optarg;
		play = true;
		break;

	    case '?':
	    default:
			cerr << "no match: " << c << endl;
		break;
	} // switch
    } // while
	
    _p_particle = new Particle[_no_particles];
    long ground = (long)(0.8*(float)window_height) << 16;

    _mid_point = window_width*0xFFFF / 2;
    _delta_x = window_width*0xFFFF / 4;

    _p_ground = new long [window_width];

    for(i = 0; i < window_width; i++)
	_p_ground[i] = ground;

    _last_index = _no_particles;

    if(SDL_Init(SDL_INIT_VIDEO) < 0) {
	cerr << "Could not initialize SDL video" << endl;
	exit(-1);
    } // if
    atexit(SDL_Quit);

    Uint32 flags = SDL_HWPALETTE;

    if(full_screen) flags |= SDL_FULLSCREEN;
    if(dual_processor) flags |= SDL_ASYNCBLIT;

    screen = SDL_SetVideoMode(window_width, window_height, 8, flags);
    SDL_SetColors(screen, colors, 0, 256);

    if(!screen) {
	cerr << argv[0] << "could not SetVideoMode() - abort" << endl;
	exit(-1);
    } // if

    size_line = screen->pitch;

    if(protocol_filename) {
	if(play) {
	    p_play_stream = new ifstream(protocol_filename);
	    if(p_play_stream->bad()) {
		cerr << "could not open " << protocol_filename << endl;
		goto exit_app;
	    } // if
	} // if
	else {
	    p_proto_stream = new ofstream(protocol_filename);

	    if(p_proto_stream->bad()) {
		cerr << "could not open " << protocol_filename << endl;
		goto exit_app;
	    } // if
	    
	    *p_proto_stream << "window_width " << window_width << endl;
	    *p_proto_stream << "window_height " << window_height << endl;
	} // else
    } // if

    ftime(&first_delay_time);
    initial_time = first_delay_time;
    play_file_time = 0;

    for(;;) {

	if(play && p_play_stream) {

	    if((SDL_PollEvent(&event) == 0) && (event.type == SDL_KEYDOWN)) 
		goto exit_app;

	    char test_string[80];

	    compare_time = GetCurMilSec(&initial_time);

	    if(compare_time >= play_file_time) {
		*p_play_stream >> test_string;
	    } // if
	    else test_string[0] = 0;

	    if(strcmp(test_string, "window_width") == 0) {
		*p_play_stream >> test_string;		
		base_width = (long)atoi(test_string);
	    } // if

	    if(strcmp(test_string, "window_height") == 0) {
		*p_play_stream >> test_string;		
		base_height = (long)atoi(test_string);
	    } // if

	    if(strcmp(test_string, "@") == 0) {
		*p_play_stream >> test_string;		
		play_file_time = (long)atoi(test_string);
	    } // if

	    if(strcmp(test_string, "motion") == 0) {
		prev_point = current_point;
		*p_play_stream >> test_string;
		current_point.x = atoi(test_string)*window_width/base_width;
		*p_play_stream >> test_string;
		current_point.y = atoi(test_string)*window_height/base_height;
	    } // if

	    if(strcmp(test_string, "l_button") == 0) {
		
		*p_play_stream >> test_string;
		if(strcmp(test_string, "down") == 0) {
		    _left_button_pressed = true;
		} // if

		if(strcmp(test_string, "up") == 0) {
		    _left_button_pressed = false;
		} // if
	    } // if

	    if(strcmp(test_string, "stop") == 0) {
		if(p_play_stream) delete p_play_stream;
		if(play) p_play_stream = new ifstream(protocol_filename);

		ftime(&first_delay_time);
		initial_time = first_delay_time;
		play_file_time = 0;
	    } // if

	} // if

	if((!play) && (SDL_PollEvent(&event) != 0)) {

	    compare_time = GetCurMilSec(&initial_time);

	    switch(event.type) {
		
		case SDL_MOUSEMOTION:
		    
		    if((compare_time != last_compare_time) && ((event.motion.x != current_point.x) || (event.motion.y != current_point.y))) {

			last_compare_time = compare_time;
			
			if(_left_button_pressed) {		
			    if(p_proto_stream) *p_proto_stream << "motion " << event.motion.x << " " << event.motion.y << " @ " << compare_time << endl;
			} // if
			
			prev_point = current_point;
			current_point = event.motion;
		    } // if
//		    else goto spray_now;
		    break;
		    
		case SDL_MOUSEBUTTONDOWN:
		    if(p_proto_stream) *p_proto_stream << "motion " << current_point.x << " " << current_point.y << " @ " << compare_time << endl;
		    if(p_proto_stream) *p_proto_stream << "motion " << current_point.x << " " << current_point.y << " @ " << compare_time << endl;
		    if(p_proto_stream) *p_proto_stream << "l_button down @ " << compare_time << endl;
		    _left_button_pressed = true;
		    break;
		    
		case SDL_MOUSEBUTTONUP:
		    if(p_proto_stream) *p_proto_stream << "l_button up @ " << compare_time << endl;
		    _left_button_pressed = false;
		    break;
		    
		case SDL_KEYDOWN:
		    
		    switch(event.key.keysym.sym) {
			
			case 27:
			case 'q':
			case 'Q':
			    goto exit_app;
			    
			default:
			    break;
		    } // switch
	    } // switch
	} // if
	else {

	spray_now:
	    
	    // make sure to stay for a while
	    
	    long start_time = simul_time;
	    
	    SDL_LockSurface(screen);
	    
	    last_time = current_time;
	    
	    if(update_min_x < 20000) {
		
		if(update_min_x < 0) update_min_x = 0;
		if(update_min_y < 0) update_min_y = 0;
		if(update_max_x >= window_width) update_max_x = window_width-1;
		if(update_max_y >= window_height) update_max_y = window_height-1;
		
		long update_height = (update_max_y - update_min_y);
		if(update_height < 0) update_height = 0;
		
		SDL_UnlockSurface(screen);
		SDL_UpdateRect(screen, update_min_x, update_min_y, update_max_x - update_min_x, update_height);
		SDL_LockSurface(screen);
		update_min_x = update_min_y = 20000;
		update_max_x = update_max_y = 0;
	    } // if
	    
	    
	    for(i = 0; i < _last_index; i++) {
		
		index_particle++;
		simul_time++;
		
		if(index_particle > _last_index) _last_index = index_particle;
		
		if(index_particle >= _no_particles) {
		    index_particle = 0;
		} // if
		
		if(_left_button_pressed || _auto_move) {
		    
		    if((rand() % (1010 - _emission_speed)) == 0) {
			long local_x, local_y;
			
			local_x = current_point.x + i*(long)(prev_point.x - current_point.x)/_last_index;
			local_y = current_point.y + i*(long)(prev_point.y - current_point.y)/_last_index;
			
			EmmitNewParticle(local_x, local_y);
		    } // if		
		} // if
		
		if(_auto_move) {
		    
		    long local_width, local_height;
		    long delta_width, delta_height;
		    
		    local_width = (long)(0.9*(float)window_width);
		    local_height = (long)(0.9*(float)window_height);
		    
		    delta_width = (long)(0.05*(float)window_width);
		    delta_height = (long)(0.05*(float)window_height);
		    
		    prev_point.x = (long)(sin((double)simul_time / ((double)(104 - sqrt(_speed_auto_move)*8) * 10000.0*1.1))*local_width/2 + local_width/2 + delta_width);
		    prev_point.y = (long)(cos((double)simul_time / ((double)(104 - sqrt(_speed_auto_move)*8) * 10000.0))*local_height*2/5 + local_height*2/5 + delta_height);
		    current_point.x = (long)(sin((double)simul_time / ((double)(104 - sqrt(_speed_auto_move)*10) * 10000.0*1.1))*local_width/2 + local_width/2 + delta_width);
		    current_point.y = (long)(cos((double)simul_time / ((double)(104 - sqrt(_speed_auto_move)*10) * 10000.0))*local_height*2/5 + local_height*2/5 + delta_height);
		    
		} // if
		
		if(_p_particle[i].IsActive()) {
		    
		    // update by chance
		    
		    particle_valid = _p_particle[i].GetSecondYoungestPosition(second_oldest_pos_x, second_oldest_pos_y, lifetime);
		    
		    pos_x = _p_particle[i].pos_x;
		    pos_y = _p_particle[i].pos_y;
		    
		    if(!((abs(((long)second_oldest_pos_x << 16) - pos_x) < (1 << 16)) && (abs(((long)second_oldest_pos_y << 16) - pos_y) < (1 << 16)))) {
			if(!_p_particle[i].Vanished()) {
			    
			    if((lifetime > 50) && (_p_particle[i]._generation < (_no_explosions-1))) {
				
				long new_particle_index;
				
				for(int repeat = 0; repeat < 5; repeat++) {
				    new_particle_index = EmmitNewParticle(pos_x >> 16, pos_y >> 16);
				    
				    if(new_particle_index >= 0) {
					_p_particle[new_particle_index]._generation = _p_particle[i]._generation+1;
				    } // if
				} // for
				
				_p_particle[i].SetVanished();
			    } // if
			} // if
			
			if(!_p_particle[i].Vanished()) {
			    
			    long current_x = pos_x >> 16;
			    long current_y = pos_y >> 16;
			    
			    if((current_x >= 0) && (current_x < window_width) &&
			       (current_y >= 0) && (current_y < window_height)) {
				
				((unsigned char*)screen->pixels)[current_x + current_y*size_line] = 255;
				
				if(update_min_x > current_x) update_min_x = current_x;
				if(update_max_x < current_x) update_max_x = current_x;
				if(update_min_y > current_y) update_min_y = current_y;
				if(update_max_y < current_y) update_max_y = current_y;
			    } // if
			    
			    if(particle_valid) {
				
				if((second_oldest_pos_x >= 0) && (second_oldest_pos_x < window_width) &&
				   (second_oldest_pos_y >= 0) && (second_oldest_pos_y < window_height)) {
				    short color;
				    
//				    color = 255/(lifetime/40+1) + 0;
				    color = 255-lifetime*3;
				    if(color < 1) color = 1;
				    
				    ((unsigned char*)screen->pixels)[second_oldest_pos_x + second_oldest_pos_y*size_line] = (unsigned char)color;
				} // if
				
			    } // if
			    
			    _p_particle[i].PushPosition();
			} // if
			
			if(_p_particle[i].GetOldestPosition(old_pos_x, old_pos_y)) {
			    int current_x = old_pos_x;
			    int current_y = old_pos_y;
			    
			    if((old_pos_x >= 0) && (old_pos_x < window_width) &&
			       (old_pos_y >= 0) && (old_pos_y < window_height)) {
				
				((unsigned char*)screen->pixels)[old_pos_x + old_pos_y*size_line] = 0;
				if(update_min_x > current_x) update_min_x = current_x;
				if(update_max_x < current_x) update_max_x = current_x;
				if(update_min_y > current_y) update_min_y = current_y;
				if(update_max_y < current_y) update_max_y = current_y;
			    } // if
			} // if
			
		    } // if
		    
		    _p_particle[i].pos_x += _p_particle[i].direction_x;
		    _p_particle[i].pos_y += _p_particle[i].direction_y;
		    
		    _p_particle[i].direction_x += _p_particle[i].gravity_x;
		    _p_particle[i].direction_y += _p_particle[i].gravity_y;
		    
		    _p_particle[i].gravity_y += (int)(_gravity_constant * (float)0xFFFF);
		    long position = _p_particle[i].pos_x >> 16;
		    if(position < 0) position = 0;
		    if(position >= window_width) position = window_width-1;
		    
//		    ground = _p_ground[position];
		    
		    if(_p_particle[i].pos_y > ground) {
			
			bool inside = false;
			
			if((_p_particle[i].pos_x <= _mid_point+_delta_x) && (_p_particle[i].pos_x >= _mid_point-_delta_x)) {
			    
			    inside = true;
			    
			    _p_particle[i].direction_y /= (long)-_gravity;
			    _p_particle[i].pos_y = ground + (ground - _p_particle[i].pos_y);
			    
			    _p_particle[i].gravity_x = 0;
			    _p_particle[i].gravity_y = 0;
			} // if
			
			if(((_p_particle[i].direction_y > (long)(-0.6*(float)0xFFFF)) && (inside == true)) || (_p_particle[i].pos_y > window_height*0xFFFF)) {
			    
			    long position = _p_particle[i].pos_x >> 16;
/*			    
			    if((position >= 0) && (position < window_width)) {
				
				if(_p_ground[position-1] > _p_ground[position]) position = position-1;
				if(_p_ground[position+1] > _p_ground[position]) position = position+1;
			    } // if
			    
			    // p_ground[position] -= (1 << 9);
*/
			    _p_particle[i].SetVanished();
			} // if				
		    } // if
		} // if
	    } // for
	    
	    ftime(&second_delay_time);
	    
	    long time2;
	    
	    time2 = (long)(1000/50) - ((long)(second_delay_time.time - first_delay_time.time)*1000l + ((long)second_delay_time.millitm - (long)first_delay_time.millitm));
	    if(time2 < 0) time2 = 0;
	    
	    SDL_Delay(time2);
	    ftime(&first_delay_time);
	    
	    SDL_UnlockSurface(screen);	    
	} // else
    } // for
    
 exit_app:

    if(p_proto_stream) {
	*p_proto_stream << "stop" << endl;
	delete p_proto_stream;  
    } // if
    if(p_play_stream) delete p_proto_stream;  
    if(_p_ground) delete[] _p_ground;
    SDL_UnlockSurface(screen);	    
    SDL_FreeSurface(screen);

	 return 0;
} // main
