// SimulationView.h : interface of the CSimulationView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SIMULATIONVIEW_H__7F95F78D_6563_11D5_AA9C_00105A3759EB__INCLUDED_)
#define AFX_SIMULATIONVIEW_H__7F95F78D_6563_11D5_AA9C_00105A3759EB__INCLUDED_

#if _MSC_VER > 400
#pragma once
#endif // _MSC_VER > 1000

#include "Particle.h"

// #define NO_PARTICLES 3600

class CSimulationView : public CView
{
protected: // create from serialization only
	CSimulationView();
	DECLARE_DYNCREATE(CSimulationView)

// Attributes
public:
	CSimulationDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSimulationView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSimulationView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;

#endif

protected:
	Particle*    _p_particle;
	long		 _no_particles, _no_glow_particles;
	int          i;
	long		 index_particle;
	long		 simul_time;
	bool		 _left_button_pressed;
	bool		 _right_button_pressed;
	CPoint    _current_point;
	long		 _last_index;
	bool		 _do_initialize;
	long		 _none_moving_count;
	float     _gravity_constant;
	bool		 _auto_move;
	long      _emission_speed, _emission_size, _no_explosions, _gravity;
	long      _speed_auto_move;

	long      _client_width, _client_height;
	long      _ground, _mid_point, _delta_x;

	long EmmitNewParticle(int, int);


// Generated message map functions
protected:
	//{{AFX_MSG(CSimulationView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSetup();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnAutoMove();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in SimulationView.cpp
inline CSimulationDoc* CSimulationView::GetDocument()
   { return (CSimulationDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SIMULATIONVIEW_H__7F95F78D_6563_11D5_AA9C_00105A3759EB__INCLUDED_)
