// SimulationView.cpp : implementation of the CSimulationView class
//

#include "stdafx.h"
#include "math.h"
#include "fstream.h"
#include "Simulation.h"
#include "ParameterSetup.h"

#include "SimulationDoc.h"
#include "SimulationView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimulationView

IMPLEMENT_DYNCREATE(CSimulationView, CView)

BEGIN_MESSAGE_MAP(CSimulationView, CView)
	//{{AFX_MSG_MAP(CSimulationView)
	ON_WM_LBUTTONDOWN()
	ON_WM_TIMER()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONUP()
	ON_COMMAND(IDM_SETUP, OnSetup)
	ON_WM_SIZE()
	ON_COMMAND(IDC_AUTO_MOVE, OnAutoMove)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimulationView construction/destruction

CSimulationView::CSimulationView()
{
	// TODO: add construction code here

	const long TEXT_LENGTH = 300; 
	char text[TEXT_LENGTH];

	_no_particles = 6000;

	_gravity_constant = 0.004;

	_p_particle = NULL;

	_do_initialize = true;
	_auto_move = false;

	_no_glow_particles = 22;
	_none_moving_count = 0;
	_no_explosions = 0;
	_emission_speed = 900;
	_emission_size = 6;
	_speed_auto_move = 40;

	_no_explosions = 0;
	_gravity = 4;
}

CSimulationView::~CSimulationView()
{
	if(_p_particle) delete[] _p_particle; _p_particle = NULL;
}

BOOL CSimulationView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CSimulationView drawing

void CSimulationView::OnDraw(CDC* pDC)
{
	CSimulationDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	
	if(_do_initialize) {
		_do_initialize = false;

		if(_p_particle) delete[] _p_particle;
		_p_particle = new Particle[_no_particles];

		Particle::ResetNoParticles();

		for(i = 0; i < _no_particles; i++) {
			_p_particle[i].Init(_no_glow_particles);
		} // for
		
		i = 0;
		index_particle = 0;
		simul_time = 0;
		_last_index = _no_particles;
		
		_left_button_pressed = _right_button_pressed = false;
		SetTimer(1, 5, NULL);
	} // if

	CPen  white_pen(PS_SOLID, 1, RGB(255, 255, 255));
	CPen* p_old_pen;
//	CPen  blue_pen(PS_SOLID, 1, RGB(0, 0, 64));
//	p_old_pen = pDC->SelectObject(&blue_pen);
/*
	for(int y = 0; y < _client_height; y++) {
		pDC->MoveTo(0, y);
		pDC->LineTo(_client_width, y);
	} // for
*/
	pDC->PatBlt(0, 0, 1280, 1024, BLACKNESS);

	p_old_pen = pDC->SelectObject(&white_pen);

	pDC->MoveTo((long)(_mid_point-_delta_x) >> 16, (_ground >> 16) + 2);
	pDC->LineTo((long)(_mid_point+_delta_x) >> 16, (_ground >> 16) + 2);

	pDC->SelectObject(p_old_pen);

	pDC->SetTextColor(RGB(255, 255, 0));
	pDC->SetBkColor(RGB(0, 0, 0));

	char text[300];

	sprintf(text, "Click left mouse button");
	pDC->TextOut(16, 16, text);
}

/////////////////////////////////////////////////////////////////////////////
// CSimulationView diagnostics

#ifdef _DEBUG
void CSimulationView::AssertValid() const
{
	CView::AssertValid();
}

void CSimulationView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSimulationDoc* CSimulationView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSimulationDoc)));
	return (CSimulationDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSimulationView message handlers

void CSimulationView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnLButtonDown(nFlags, point);

	_current_point = point;
	_left_button_pressed = true;
}

long CSimulationView::EmmitNewParticle(int x, int y)
{
	long current_particle_index;

	if(!_p_particle[index_particle].IsActive()) {
		
		_p_particle[index_particle].Init(_no_glow_particles);
		
		_p_particle[index_particle].pos_y = (long)((long)y + (rand() % _emission_size) - _emission_size/2) << 16;
		_p_particle[index_particle].pos_x = (long)((long)x + (rand() % _emission_size) - _emission_size/2) << 16;
		
		static float drive;
		
		drive = (float)(rand() % 500)/150+1;
		
		_p_particle[index_particle].direction_x = (long)((float)((rand() % 400) - 200)/200.0*(float)0xFFFF);
		_p_particle[index_particle].direction_y = (long)(-drive*(float)0xFFFF);
		
		_p_particle[index_particle].gravity_x = 0;
		_p_particle[index_particle].gravity_y = 0;
		
		_p_particle[index_particle].SetActive(true);
		
		current_particle_index = index_particle;

		index_particle++;

		if(index_particle >= _no_particles) {
			index_particle = 0;
		} // if

		if(index_particle > _last_index) _last_index = index_particle;
		
		return current_particle_index;
	} // if

	return -1;
} // CSimulationView::EmmitNewParticle

void CSimulationView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnTimer(nIDEvent);
	
	CClientDC dc(this);
	short     old_pos_x, old_pos_y;
	short	  second_oldest_pos_x, second_oldest_pos_y;
	long	  pos_x, pos_y;
	long      lifetime;
	bool      particle_valid;
	
	long start_time = simul_time;
	
	// make sure to stay for a while
	
	while((simul_time - start_time) < 5000) {
		
		for(i = 0; i < _last_index; i++) {
			
			index_particle++;
			
			if(index_particle > _last_index) _last_index = index_particle;
			
			if(index_particle >= _no_particles) {
				index_particle = 0;
			} // if
			
			simul_time++;
			
			if((simul_time % 15000) == 0) {
				char text[80];
				
				dc.SetTextColor(RGB(255, 255, 0));
				dc.SetBkColor(RGB(0, 0, 0));
				
				sprintf(text, "%d Partikel  ", Particle::GetNoParticles());
				dc.TextOut(16, 32, text);
			} // if
			
			if(_left_button_pressed || _auto_move) {
				
				if((rand() % (1010 - _emission_speed)) == 0) {
					
					EmmitNewParticle(_current_point.x, _current_point.y);
				} // if		
			} // if
			
			if(_right_button_pressed) {
				// blow wind into all upper particles
				
				long force_x, force_y, length;
				
				force_x = (_p_particle[i].pos_x >> 16) - (_current_point.x);
				force_y = (_p_particle[i].pos_y >> 16) - (_current_point.y);
				
				length = force_x*force_x + force_y*force_y;
				
				length = (long)sqrt((double)length);
				
				length /= 1000000;
				
				if(length == 0) length = 1;
				
				_p_particle[i].pos_x += (force_x / (length)) << 12;
				_p_particle[i].pos_y += (force_y / (length)) << 12;			
			} // if

			if(_auto_move) {

				long local_width, local_height;
				long delta_width, delta_height;

				local_width = (long)(0.9*(float)_client_width);
				local_height = (long)(0.9*(float)_client_height);

				delta_width = (long)(0.05*(float)_client_width);
				delta_height = (long)(0.05*(float)_client_height);

				_current_point.x = sin((double)simul_time / ((double)(104 - sqrt(_speed_auto_move)*10) * 10000.0*1.1))*local_width/2 + local_width/2 + delta_width;
				_current_point.y = cos((double)simul_time / ((double)(104 - sqrt(_speed_auto_move)*10) * 10000.0))*local_height*2/5 + local_height*2/5 + delta_height;
			} // if
			
			if(_p_particle[i].IsActive()) {
				
				// update by chance
				
				particle_valid = _p_particle[i].GetSecondYoungestPosition(second_oldest_pos_x, second_oldest_pos_y, lifetime);
				
				pos_x = _p_particle[i].pos_x;
				pos_y = _p_particle[i].pos_y;
				
				if(!((abs(((long)second_oldest_pos_x << 16) - pos_x) < (1 << 16)) && (abs(((long)second_oldest_pos_y << 16) - pos_y) < (1 << 16)))) {
					if(!_p_particle[i].Vanished()) {
						
						if((lifetime > 50) && (_p_particle[i]._generation < (_no_explosions-1))) {
							
							long new_particle_index;
							
							for(int repeat = 0; repeat < 5; repeat++) {
								new_particle_index = EmmitNewParticle(pos_x >> 16, pos_y >> 16);
								
								if(new_particle_index >= 0) {
									_p_particle[new_particle_index]._generation = _p_particle[i]._generation+1;
								} // if
							} // for
							
							_p_particle[i].SetVanished();
						} // if
					} // if
					
					if(!_p_particle[i].Vanished()) {
						dc.SetPixelV(pos_x >> 16, pos_y >> 16, RGB(255, 255, 255));
						
						if(particle_valid) {
							
							short color_1, color_2;
							
							color_1 = 210/(lifetime/92+1) + 45;
							color_2 = 255/(lifetime/40+1) + 0;
							
							dc.SetPixelV(second_oldest_pos_x, second_oldest_pos_y, RGB(color_1, color_2, 0));
						} // if
						
						_p_particle[i].PushPosition();
					} // if
					
					if(_p_particle[i].GetOldestPosition(old_pos_x, old_pos_y)) {
						dc.SetPixelV(old_pos_x, old_pos_y, RGB(0, 0, 0));
					} // if
				} // if
				
				_p_particle[i].pos_x += _p_particle[i].direction_x;
				_p_particle[i].pos_y += _p_particle[i].direction_y;
				
				_p_particle[i].direction_x += _p_particle[i].gravity_x;
				_p_particle[i].direction_y += _p_particle[i].gravity_y;
				
				_p_particle[i].gravity_y += (int)(_gravity_constant * (float)0xFFFF);
				
				if(_p_particle[i].pos_y > _ground) {
					
					bool inside = false;
					
					if((_p_particle[i].pos_x <= _mid_point+_delta_x) && (_p_particle[i].pos_x >= _mid_point-_delta_x)) {
						
						inside = true;
						
						_p_particle[i].direction_y /= (long)-_gravity;
						_p_particle[i].pos_y = _ground + (_ground - _p_particle[i].pos_y);
						
						_p_particle[i].gravity_x = 0;
						_p_particle[i].gravity_y = 0;
					} // if
					
					if(((_p_particle[i].direction_y > (long)(-0.6*(float)0xFFFF)) && (inside == true)) || (_p_particle[i].pos_y > 1024*0xFFFF)) {
						_p_particle[i].SetVanished();
					} // if				
				} // if
			} // if
	} // for
} // while

}

void CSimulationView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnRButtonDown(nFlags, point);

	_right_button_pressed = true;
}


void CSimulationView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnRButtonUp(nFlags, point);

	_right_button_pressed = false;
}

void CSimulationView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnMouseMove(nFlags, point);
	_current_point = point;
}

void CSimulationView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnLButtonDblClk(nFlags, point);

	_left_button_pressed = true;
}

void CSimulationView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnLButtonUp(nFlags, point);

	_left_button_pressed = false;
}

void CSimulationView::OnSetup() 
{
	// TODO: Add your command handler code here
	
	long no_particles, no_glow_particles;

	no_particles = _no_particles;
	no_glow_particles = _no_glow_particles;

	_auto_move = false;

	ParameterSetup para_setup(this, no_particles, _emission_speed, _emission_size, 
									  _no_explosions, no_glow_particles, _gravity, _speed_auto_move);
	para_setup.DoModal();

	if((no_particles != _no_particles) || (no_glow_particles != _no_glow_particles)) {

		_last_index = _no_particles = no_particles;
		index_particle = 0;

		_no_glow_particles = no_glow_particles;

		_do_initialize = true;
		Invalidate();
	} // if

	_auto_move = false;
}

void CSimulationView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here

	RECT rect;

	GetClientRect(&rect);

	_client_width = (rect.right - rect.left);
	_client_height = (rect.bottom - rect.top);	

	_ground = (long)(0.8*(float)_client_height) * 0xFFFFl;

	_mid_point = _client_width*0xFFFF / 2;
	_delta_x = _client_width*0xFFFF / 4;

}

void CSimulationView::OnAutoMove() 
{
	// TODO: Add your command handler code here

	_auto_move = !_auto_move;

	CMenu* p_menu = GetParent()->GetMenu();

	if(_auto_move)
		p_menu->CheckMenuItem(IDC_AUTO_MOVE, MF_CHECKED);
	else
		p_menu->CheckMenuItem(IDC_AUTO_MOVE, MF_UNCHECKED);	
}