// Particle.cpp: implementation of the Particle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Simulation.h"
#include "Particle.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

long Particle::_no_particles;


Particle::Particle()
{
	_p_old_pos_x = NULL;
	_p_old_pos_y = NULL;
}

Particle::~Particle()
{
	if(_p_old_pos_x) delete[] _p_old_pos_x; _p_old_pos_x = NULL;
	if(_p_old_pos_y) delete[] _p_old_pos_y; _p_old_pos_y = NULL;
}

void Particle::Init(long no_glow_particles)
{
	_max_old_positions = no_glow_particles;

	if(_p_old_pos_x) delete[] _p_old_pos_x;
	_p_old_pos_x = new short[_max_old_positions];

	if(_p_old_pos_y) delete[] _p_old_pos_y;
	_p_old_pos_y = new short[_max_old_positions];

	_old_pos_index = 0; 
	_active = false; 
	_no_old_positions = 0; 
	_current_oldest_pos = 0;
	_life_time = 1;
	_vanished = false;
	_generation = 1;
} // Particle::Init