// ParameterSetup.cpp : implementation file
//

#include "stdafx.h"
#include "Simulation.h"
#include "ParameterSetup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ParameterSetup dialog

ParameterSetup::ParameterSetup(CWnd* p_parent_win, long& no_particles, long& emission_speed,
										 long& emission_size, long& no_explosions, long& no_glow_particles,
										 long& gravity, long& speed_auto_move)
	: CDialog(ParameterSetup::IDD, (CWnd*)p_parent_win)
{
	//{{AFX_DATA_INIT(ParameterSetup)
	//}}AFX_DATA_INIT

	_p_parent = p_parent_win;

	_p_no_particles = &no_particles;
	_p_emission_speed = &emission_speed;
	_p_emission_size = &emission_size;
	_p_no_explosions = &no_explosions;
	_p_no_glow_particles = &no_glow_particles;
	_p_gravity = &gravity;
	_p_speed_auto_move = &speed_auto_move;

	_leave_dialog = false;
}


void ParameterSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ParameterSetup)
	DDX_Control(pDX, IDC_SPEED_AUTO_MOVE, m_speed_auto_move);
	DDX_Control(pDX, IDC_EMISSION_SIZE, m_emission_size);
	DDX_Control(pDX, IDC_EMISSION_SPEED, m_emission_speed);
	DDX_Control(pDX, IDC_GRAVITY, m_gravity);
	DDX_Control(pDX, IDC_MAX_PARTICLES, m_max_particle);
	DDX_Control(pDX, IDC_GLOW_PARTICLES, m_glow_particle);
	DDX_Control(pDX, IDC_EXPLOSITIONS, m_explosions);
	//}}AFX_DATA_MAP

	long no_particles;
	char text[100];

	if(!_leave_dialog) {
		sprintf(text, "%d", *_p_no_particles);
		m_max_particle.SetWindowText(text);

		sprintf(text, "%d", *_p_emission_speed);
		m_emission_speed.SetWindowText(text);

		sprintf(text, "%d", *_p_emission_size);
		m_emission_size.SetWindowText(text);

		sprintf(text, "%d", *_p_no_explosions);
		m_explosions.SetWindowText(text);

		sprintf(text, "%d", *_p_no_glow_particles);
		m_glow_particle.SetWindowText(text);

		sprintf(text, "%d", *_p_gravity);
		m_gravity.SetWindowText(text);

		sprintf(text, "%d", *_p_speed_auto_move);
		m_speed_auto_move.SetWindowText(text);

		_leave_dialog = true;
		SetTimer(2, 500, NULL);
	} // if
	else {
		KillTimer(2);
		m_max_particle.GetWindowText(text, 100);
		no_particles = atoi(text);
		if((no_particles >= 0) && (no_particles <= 20000)) {
			*_p_no_particles = no_particles;
		} // if
	} // else
}


BEGIN_MESSAGE_MAP(ParameterSetup, CDialog)
	//{{AFX_MSG_MAP(ParameterSetup)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ParameterSetup message handlers

void ParameterSetup::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
	ProcessInput();
}

void ParameterSetup::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	ProcessInput();

	CDialog::OnTimer(nIDEvent);
}

void ParameterSetup::ProcessInput()
{
	char text[100];
	long value;

	_p_parent->SendMessage(WM_COMMAND, IDC_AUTO_MOVE);	

	m_emission_speed.GetWindowText(text, 100);
	value = atoi(text);
	if((value >= 1) && (value <= 1000)) {
		*_p_emission_speed = value;
	} // if

	m_emission_size.GetWindowText(text, 100);
	value = atoi(text);
	if((value >= 1) && (value <= 400)) {
		*_p_emission_size = value;
	} // if

	m_explosions.GetWindowText(text, 100);
	value = atoi(text);
	if((value >= 0) && (value <= 4)) {
		*_p_no_explosions = value;
	} // if

	m_glow_particle.GetWindowText(text, 100);
	value = atoi(text);
	if((value >= 2) && (value <= 60)) {
		*_p_no_glow_particles = value;
	} // if

	m_gravity.GetWindowText(text, 100);
	value = atoi(text);
	if((value >= 1) && (value <= 4)) {
		*_p_gravity = value;
	} // if

	m_speed_auto_move.GetWindowText(text, 100);
	value = atoi(text);
	if((value >= 1) && (value <= 100)) {
		*_p_speed_auto_move = value;
	} // if
}