// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "gol.h"
#include "ChildView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WIDTH  256
#define HEIGHT 256

#define SCALE_FACTOR 2
#define SET_RADIUS   4

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	for(int i = 0; i < 2; i++) {
		_p_field[i] = new unsigned char [WIDTH*HEIGHT];

		for(int y = 0; y < HEIGHT; y++) {
			for(int x = 0; x < WIDTH; x++) {
				_p_field[i][x + y*WIDTH] = 0;
			} // for
		} // for
	} // for

	_current_field = 0;
	_button_pressed = false;

	_timer_set = false;
}

CChildView::~CChildView()
{
	for(int i = 0; i < 2; i++)
		delete[] _p_field[i];
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_TIMER()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages

	dc.MoveTo(0, HEIGHT*SCALE_FACTOR);
	dc.LineTo(WIDTH*SCALE_FACTOR, HEIGHT*SCALE_FACTOR);
	dc.LineTo(WIDTH*SCALE_FACTOR, 0);
}


void CChildView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd ::OnLButtonDown(nFlags, point);

	CClientDC dc(this);

	int x, y;

	_button_pressed = true;
/*
	for(int i = 0; i < WIDTH*HEIGHT/5; i++) {

		x = rand() % WIDTH;
		y = rand() % HEIGHT;

		_p_field[_current_field][x + y*WIDTH] = 1;

		dc.SetPixel(x, y, RGB(0, 0, 0));
	} // for
*/
}

void CChildView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd ::OnLButtonUp(nFlags, point);

	_button_pressed = false;
}

void CChildView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CClientDC dc(this);

	CWnd ::OnMouseMove(nFlags, point);

	if(_button_pressed) {

		for(int dy = -SET_RADIUS; dy < SET_RADIUS; dy++) {
			for(int dx = -SET_RADIUS; dx < SET_RADIUS; dx++) {

				if((rand() % 6) == 1) {

					if((point.x/SCALE_FACTOR+dx < WIDTH) && (point.y/SCALE_FACTOR+dy < HEIGHT)) {
						_p_field[_current_field][point.x/SCALE_FACTOR+dx + (point.y/SCALE_FACTOR+dy)*WIDTH] = 1;

						dc.SetPixel((point.x/SCALE_FACTOR+dx)*SCALE_FACTOR, (point.y/SCALE_FACTOR+dy)*SCALE_FACTOR, RGB(0, 0, 0));
					} // if
				} // if
			} // for
		} // for
	} // if
}

void CChildView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd ::OnTimer(nIDEvent);

	CClientDC		dc(this);
	CDC				memory_dc;
	CBitmap*			p_old_bitmap;
	unsigned char  temp_field[WIDTH*3];

	int				x, y;

	memory_dc.CreateCompatibleDC(&dc);

	CBitmap memory_bitmap;

	memory_bitmap.CreateBitmap(WIDTH, 1, 1, 24, NULL);

	p_old_bitmap = memory_dc.SelectObject(&memory_bitmap);

	int start_x, end_x, start_y, end_y;
	int neighbor_count, new_field;

	unsigned char color;

	if(_current_field == 0) new_field = 1;
	else new_field = 0;

/*
	for(int i = 0; i < WIDTH*HEIGHT/50; i++) {

		x = rand() % WIDTH;
		y = rand() % HEIGHT;

		_p_field[_current_field][x + y*WIDTH] = 1;

		dc.SetPixel(x, y, RGB(0, 0, 0));
	} // for
*/

	for(y = 0; y < HEIGHT; y++) {

		start_y = y - 1; end_y = y + 1;

		if(start_y < 0) start_y = 0;
		if(end_y >= HEIGHT) end_y = HEIGHT-1;

		for(int x = 0; x < WIDTH; x++) {

			start_x = x - 1; end_x = x + 1;

			if(start_x < 0) start_x = 0;
			if(end_x >= WIDTH) end_x = WIDTH-1;

			neighbor_count = 0;

			for(int dy = start_y; dy <= end_y; dy++) {

				unsigned char* p_work_field = &(_p_field[_current_field][start_x + dy*WIDTH]);

				for(int dx = start_x; dx <= end_x; dx++) {
					if(*(p_work_field++) != 0) neighbor_count++;
				} // for
			} // for

			if(neighbor_count != 0) {

				if(_p_field[_current_field][x + y*WIDTH] != 0) {

					neighbor_count -= _p_field[_current_field][x + y*WIDTH];

					if((neighbor_count < 2) || (neighbor_count > 3))
						_p_field[new_field][x + y*WIDTH] = 0;
					else
						_p_field[new_field][x + y*WIDTH] = 1;
				} // if
				else {
					if(neighbor_count == 3)
						_p_field[new_field][x + y*WIDTH] = 1;
				} // else
			} // if
		} // for
	} // for

	for(y = 0; y < HEIGHT; y++) {

		unsigned char* p_work_current_field = &(_p_field[_current_field][y*WIDTH]);
		unsigned char* p_work_temp_field = temp_field;

		for(int i = 0; i < WIDTH; i++) {

			unsigned char state = 0xFF ^ (*p_work_current_field)*255;

			*(p_work_temp_field++) = state;
			*(p_work_temp_field++) = state;
			*(p_work_temp_field++) = state;

			*p_work_current_field = 0;
			p_work_current_field++;
		} // for

		memory_bitmap.SetBitmapBits(WIDTH*3, temp_field);
		dc.StretchBlt(0, y*SCALE_FACTOR, WIDTH*SCALE_FACTOR, 1*SCALE_FACTOR, &memory_dc, 0, 0, WIDTH, 1, SRCCOPY);
	} // for

	memory_dc.SelectObject(p_old_bitmap);

	if(_current_field == 0) _current_field = 1;
	else _current_field = 0;
}

void CChildView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd ::OnRButtonDown(nFlags, point);

	if(!_timer_set) {
		SetTimer(1, 50, NULL);
		_timer_set = true;
	} // if
	else {
		KillTimer(1);
		_timer_set = false;
	} // else
}
